/**
 * GstreamerVideoSinkRecord.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: S. Pujari / RBEI/ECF3 / SonaliSajan.Pujari@in.bosch.com
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/


#include <errno.h>
#include <adit_logging.h>
#include "GstreamerVideoSinkRecord.h"


LOG_IMPORT_CONTEXT(aauto_video)

namespace adit { namespace aauto {

void GstreamerVideoSinkRecord::open(std::string fileName, std::string sinkName) {

    if (fileName.empty() || sinkName.empty()) {
        LOG_ERROR((aauto_video, "GstreamerVideoSinkRecord::open() Input parameter are invalid"));

    } else {
        /*assign VideoSink name for DLT logging */
        mSinkName.assign(sinkName);

        /* create and open file */
        videoFrameFile = fopen(fileName.c_str(), "w+");
        if (!videoFrameFile) {
            LOG_ERROR((aauto_video, "%s, GstreamerVideoSinkRecord() Open file %s failed, errno=%d",
                    mSinkName.c_str(), fileName.c_str(), errno));

        } else {
            LOGD_DEBUG((aauto_video, "%s, GstreamerVideoSinkRecord() Open file %s with Id=%p",
                    mSinkName.c_str(), fileName.c_str(), videoFrameFile));

        }
    }

    return;
}

void GstreamerVideoSinkRecord::close() {

    if (videoFrameFile != nullptr) {
        LOGD_DEBUG((aauto_video, "%s, GstreamerVideoSinkRecord() Close file %p",mSinkName.c_str(), videoFrameFile));
        fclose(videoFrameFile);
        videoFrameFile = nullptr;
    }
    else
    {
        LOG_ERROR((aauto_video, "close() videoFrameFile is not open!"));
    }

    return;
}

int GstreamerVideoSinkRecord::write(const void *ptr, unsigned int size) {
    int res = 0;
    if (videoFrameFile != nullptr) {
        if (fwrite((char*)ptr, size,1,videoFrameFile) > 0)
        {
            LOGD_VERBOSE((aauto_video, "%s Write data(len=%d) to file %p complete",
                    mSinkName.c_str(), size, videoFrameFile));
            res = (int)size;
        } else {
            LOG_WARN((aauto_video, "%s Write data(len=%d) to file %p failed errno=%d",
                    mSinkName.c_str(), size, videoFrameFile, errno));
        }
    } else {
        LOG_WARN((aauto_video, "%s, GstreamerVideoSinkRecord() Write failed because file not open.",
                mSinkName.c_str()));
        res = -1;
    }

    return res;
}


} } /* namespace adit { namespace aauto */
